;/* $Header: /lsid/semaphore/clarinet/custom/srcset_.h 1.6 1997/03/21 00:55:18 donm Exp $ */
;/* (C) Copyright 1996, Hewlett-Packard Company, all rights reserved. */
;/* */
;/* This is the unix version of the dos file. */
;/* Use "ux2dos' and "dos2ux" to convert. */

;/*######################################################################### */
;/*#### WARNING: THIS FILE IS USED BY CUSTOM SIGNAL MODES (srcusr.asm) ##### */
;/*######################################################################### */

;/*######################################################################### */
;/*	Source Register values */
;/*######################################################################### */

;/* */
;/* Analog Control Register (Fsrc_acr, $FFFB, write, keep local version) */
;/* */

        define FSRC_ACR		'$FFFB'

; extern int src_acr;
;     1 channel bd
	define	FACR_INIT	'$018416'
;     2 channel bd
	define	FACR_INIT2	'$218416'
;	/* df,hi,50,cola,192,nocal,nofs,led off,noirqs */
; 	/* df,rfhi,ch1_50,nocola or sum,df192,nocal,framesyncoff,leds off, */
;	/* noirqs,ch2_50,1 or 2 ch, pathnormal */

;/*	bit 0 = 0 = no df bypass */
;		/*		1 = bypass DF17OO */
;		/*		0 = DF17OO in path */
;/*	bit 1 = 1 = 25.6kHz filter */
;		/*		1 = high filter, 25.6 kHz */
;		/*		0 = low filter, 6.4 kHz */
;/*	bit 2 = 1 output 50 Ohms to GND (CH2 is bit 16) */
;		/*		1 = 50 Ohms to GND */
;		/*		0 = no resistor to GND */
;/*	bit 3 = 0 =  sum/cola  control */
;		/*		see bit 7 for sum/cola control */
;/*	bit 4 = 1 = x192 DF1700 */
;		/* 		1 = 192 DF1700 clk div */
;		/* 		0 = 256 DF1700 clk div */
;/*	bit 5 = 0 Cal not to substrate */
;		/*		1 = substrate to source cal */
;		/*		0 = no substrate to source cal */
;/*	bit 6 = 0 Cal not connected to output */
;		/*		1 = source cal buffer to output conn */
;		/*		0 = source output amp to output conn */
;/*	bit 7 = 0 sum/cola control */
;		/*		7,3
;		/*		00 = no sum and no cola
;		/*		10 = COLA out
;		/*		01 = Sum in
;		/*		11 = illegal, dont use
;/*	bit 8 = 0 framesync off */
;/*	bit 9 = 0 framesync off */
;		/* bit 8, frmsync0, frame sync clock control bit 0 */
;		/* bit 9, frmsync1, frame sync clock control bit 1 */
;		/*			00 = always off */
;		/*			01 = trigger */
;		/*			10 = always on */
;/*	bits 10 = 1 frame sync doesn't turn on LED, LED off */
;/*	bits 11 = 0  LED not forced on, LED off */
; 		/*bit 10, led_fsn1, frame sync controls LED
;				1 = frame sync doesn't turn on LED
;				0 = LED on when in sample and postsample state
;               /*bit 15, led_fsn2, frame sync controls LED
;                               1 = frame sync doesn't turn on LED
;                               0 = LED on when in sample and postsample state
;		/*bit 11, led_on, both LED forced on
;				0 = LED not forced on (controlled by led_fsn bit)
;				1 = LED forced on. (LED on regardless of led_fsn.)
;				     	15,11,10
;					000 = LED 1 & 2 on/off with FRAMESYNC
;					x1x = both LEDs ON
;					101 = both LED OFF
;/*	bits 12 = 0, irqs disabled */
;				1 = irqs enabled
;/*	bits 13 = 0, ch1 overload irq disabled */
;
;/*	bits 14 = 0, ch2 overload irq disabled */
;
;/*	bits 15 = 1 frame sync doesn't turn on LED ch 2, LED off */
;
;/*	bits 16 = 1 ch 2 output 50 Ohms to GND */

;/*	bits 17-23 = 0 not used in Fsrc_acr */
;
;/* in Fvar_src_acr bits 17-23 defined as follows: */
;
;/*	bits 17-20 = 0 not used in ;Fvar_src_acr */
;
;/*	bit 21 = 0 one channel */
;		/*		1 = 2 channel */
;		/*		0 = one channel */
;
;/*	bit 22 = 0 not used */
;
;/*	bit 23 = 0 normal source output paths */
;		/*		1 = dont change source path with on and off */
;		/*		0 = normal source output paths with on and off*/
;

;/* */
;/* Analog Status Register (Fsrc_asr, $FFFE, read) */
;/* */

        define FSRC_ASR		'$FFFE'

;extern int src_asr;

	define	FASR_OVLD      '$800000'	;/* bit 23, NMI, level */
	define	FASR_ADCBUSY   '$400000'	;/* bit 22, level */
	define	FASR_USERSD    '$200000'	;/* bit 21, level */
	define	FASR_USERSDINT '$100000' ;/* bit 20, p/o irqb, clear on read */
	define	FASR_ACFAIL    '$080000' ;/* bit 19, p/o irqb, clear on read */
	define	FASR_SYNCDONE  '$040000' ;/* bit 18, p/o irqb, clear on read */
	define	FASR_RST96Q    '$020000' ;/* bit 17, p/o irqb, clear on read */
	define	FASR_PLOCK     '$010000'	;/* bit 16 */
	define	FASR_OVLD2     '$008000'	;/* bit 15, NMI, level */

	define	FASR_OVLD_BIT      '23'	;/* bit 23, NMI, level */
	define	FASR_ADCBUSY_BIT   '22'	;/* bit 22, level */
	define	FASR_USERSD_BIT    '21'	;/* bit 21, level */
	define	FASR_USERSDINT_BIT '20' ;/* bit 20, p/o irqb, clear on read */
	define	FASR_ACFAIL_BIT    '19' ;/* bit 19, p/o irqb, clear on read */
	define	FASR_SYNCDONE_BIT  '18' ;/* bit 18, p/o irqb, clear on read */
	define	FASR_RST96Q_BIT    '17' ;/* bit 17, p/o irqb, clear on read */
	define	FASR_PLOCK_BIT     '16'	;/* bit 16, */
	define	FASR_OVLD2_BIT     '15'	;/* bit 15, NMI, level */

;/* */
;/* Source Interrupt Status Register (Fsrc_sisr, $FFF8, write) */
;/* */

        define FSRC_SISR	'FFF8'

;/*					     bit    Similar Amadeus */
;/*					   96k/56k  bit		    */
    	define	FSISR_BOOTED	'$400000' ;/* 30/22   PON	    */
    	define	FSISR_BOOTED_BIT		'22'
    	define	FSISR_OVERREAD	'$200000' ;/* 29/21   FSFAST	    */
    	define	FSISR_OVERREAD_BIT	'21'
;/*				DAC Overread Data error		    */
    	define	FSISR_OVRLD	'$100000' ;/* 28/20    OVLD	    */
    	define	FSISR_OVRLD_BIT		'20'
    	define	FSISR_TRIG	'$080000' ;/* 27/19    -	    */
    	define	FSISR_TRIG_BIT		'19'
;/*				Send a system (source) trigger	    */
    	define	FSISR_RD4START	'$040000' ;/* 26/18    -	    */
    	define	FSISR_RD4START_BIT	'18'
;/*				Measurement State Machine, MSM,Stop and */
;/*				Monitor Idle			    */
    	define	FSISR_RD4SYNC	'$020000' ;/* 25/17    - 	    */
    	define	FSISR_RD4SYNC_BIT	'17'
    	define	FSISR_RD4ARM	'$010000' ;/* 24/16    ARMRDY	    */
    	define	FSISR_RD4ARM_BIT		'16'
    	define	FSISR_RD4TRIG	'$008000' ;/* 23/15    -	    */
    	define	FSISR_RD4TRIG_BIT	'15'
    	define	FSISR_ERROR	'$004000' ;/* 22/14    ERR	    */
    	define	FSISR_ERROR_BIT		'14'
    	define	FSISR_CMDACK	'$002000' ;/* 21/13    RDY	    */
    	define	FSISR_CMDACK_BIT		'13'
    	define	FSISR_TSCLK	'$001000' ;/* 20/12    		    */
    	define	FSISR_TSCLK_BIT	'12'
    	define	FSISR_RD4WORD	'$000800' ;/* 19/11    -	    */
    	define	FSISR_RD4WORD_BIT	'11'
;/*				replaces HREQ on TXDE, ready for word */
;/*				written  from host to DSP host port */
    	define	FSISR_WORDAVAIL	'$000400' ;/* 18/10    _	    */
    	define	FSISR_WORDAVAIL_BIT	'10'
;/*				replaces HREQ on RXDF, ready for word */
;/*				to be read by host from DSP host port */
    	define	FSISR_BUFERROR	'$000200' ;/*  17/9    -	    */
    	define	FSISR_BUFERROR_BIT	'9'
    	define	FSISR_BUFRAVAIL_A '$000100' ;/*  16/8    BUFS/BUFO    */
    	define	FSISR_BUFRAVAIL_A_BIT	'8'
    	define	FSISR_BUFRAVAIL_B '$000080' ;/*  15/7    BUFS/BUFO    */
    	define	FSISR_BUFRAVAIL_B_BIT	'7'
        define	FSISR_SHUTDN     '$000040' ;/*  14/6    ISHUT        */
        define	FSISR_SHUTDN_BIT     	'6'
    	define	FSISR_SHUTDNCLRD	'$000020' ;/*  13/5    ISHUT	    */
    	define	FSISR_SHUTDNCLRD_BIT	'5'
    	define	FSISR_OVRLDCLRD	'$000010' ;/*  12/4    OVLD	    */
    	define	FSISR_OVRLDCLRD_BIT	'4'
    	define	FSISR_OUTPUTON	'$000008' ;/*  11/3    OUTPUT	    */
    	define	FSISR_OUTPUTON_BIT	'3'
		; /* MSM Meas, or Send Trig, or Rampdown */
    	define	FSISR_OUTOFF	'$000004' ;/*  10/2    OUTPUT	    */
    	define	FSISR_OUTOFF_BIT		'2'
    	define	FSISR_RAMPON	'$000002' ;/*   9/1    -       	    */
    	define	FSISR_RAMPON_BIT		'1'
    	define	FSISR_RAMPOFF	'$000001' ;/*   8/0    -            */
    	define	FSISR_RAMPOFF_BIT	'0'

;/* */
;/* Internal ADC channel (Fsrc_adc, $FFFF, write (ch), after not busy, read) */
;/* */
; bipolar mode, set bit 3
; The values read need to be converted from 12 bit twos compliment
; to 24 bit twos compliment

        define FSRC_ADC		'$FFFF'

	define	FADC_AMPOUT     '$000008'	;/* channel 0 */
	define	FADC_DACOUT     '$000009'	;/* channel 1 */
	define	FADC_RDACOUT    '$00000a'	;/* channel 2 */
	define	FADC_AMPOUTLO   '$00000b'	;/* channel 3 */
	define	FADC_CALOUT     '$00000c'	;/* channel 4 */
	define	FADC_REF	'$00000d'	;/* channel 5 */
	define	FADC_GND	'$00000e'	;/* channel 6 */
	define	FADC_FILOUT     '$00000f'	;/* channel 7 */

;/* for 2 channel source */
	define	FADC_DACOUT1_2  '$000008'	;/* channel 0 */
	define	FADC_AMPOUT1_2  '$000009'	;/* channel 1 */
	define	FADC_AMPOUT1G_2 '$00000a'	;/* channel 2 */
	define	FADC_DACOUT2_2  '$00000b'	;/* channel 3 */
	define	FADC_AMPOUT2_2  '$00000c'	;/* channel 4 */
	define	FADC_AMPOUT2G_2	'$00000d'	;/* channel 5 */
	define	FADC_CALOUT_2	'$00000e'	;/* channel 6 */
	define	FADC_GND_2      '$00000f'	;/* channel 7 */


;/* */
;/* Signal out data shift and delay constants
;/* */

	define	FSIG_DFIN_BITS	'$008000'	;/* DSP to DF, 16 bits */
	define	FSIG_DFOUT_BITS	'$080000'	;/* DSP to PCM63, 20 bits */
	define	FSIG_DFIN_DELAY	'$000036'	;/* DSP to DF, 16 bits */
	define	FSIG_DFOUT_DELAY '$000000'	;/* DSP to PCM63, 20 bits */

;/* */
;/* Range DAC locations
;/* */

        define FSRC_RNGWR	'$FFFA'
        define FSRC_RNG2WR	'$FFEA'

;/* */
;/* Board types
;/* */
        define FSRCBDID_MSK	'$f80000'
;  daughter board, 1 channel: 
        define FSRCBDID_DAU	'$300000'
;  SCA, 2 channel: 
        define FSRCBDID_SCA	'$380000'
;  daughter board, 1 channel: 
        define FSRCBD_1		'$000000'
;  SCA, 2 channel: 
        define FSRCBD_2		'$800000'

